function fish_prompt
  set_color -o red
  echo -n "> "
  set_color normal
end

# From https://github.com/mduvall/dotfiles/blob/master/fish_prompt.fish.
function fuller_prompt_cwd --description 'Print the current working directory, NOT shortened to fit the prompt'
  if test "$PWD" != "$HOME"
    printf "%s" (echo $PWD|sed -e 's|/private||' -e "s|^$HOME|~|")
  else
    echo '~'
  end
end

function fish_right_prompt
  set_color -o green
  echo -n (fuller_prompt_cwd)
  set_color normal
end

set -g fish_greeting

set -g -x EDITOR vim

if status is-interactive
  if type -p zoxide > /dev/null
    zoxide init fish | source
  end
end

# ls alias
alias la='ls -al'
alias la='ls -alh'

# git
alias g='git'
alias gcl='git clone'
alias gst='git status'
alias gp='git push'
alias gf='git fetch'
alias gl='git pull'
alias gd='git diff'
alias gc='git commit'

# alpine
alias apks='apk search'
alias apki='apk info'
alias apka='doas apk add'
